#!/usr/bin/env python3

import sys
from math import *
import numpy as np 
# import numbers


#  load input module
argvs = sys.argv
argc  = len( argvs ) 

if argc != 2 and argc != 3  :
   print(" usage : ", argvs[0], "<target_tune>  FIR_filter_file" )
   print("     for calculation of FIR filter gain(G) and phase response") 
   print("        with coeffcients( a(k) ) for k-th turn( turn(k) ):" )
   print("        G(nu) * exp( i*phase(nu) ) = sum_k=1^N ( a(k) exp( i* turn(k) * 2*pi*nu )")  
   print("     for the tune nu.") 
   print("     if target_phase is specified, effective gain is also calculated as" ) 
   print("        G_eff(nu) = G(nu)*cos( phase(nu) - target_phase )")
   print("  input file format is " )
   print("      a(1)  turn(1)")
   print("      a(2)  turn(2)")
   print("        ... ") 
   print("      a(N)  turn(N)")
   print("  OR " )
   print("      turn(1)  a(1)")
   print("      turn(2)  a(2)")
   print("          ... ") 
   print("      turn(N)  a(N)")
   print("  with the condition: turn(k) < turn(k+1) for all k,") 
   print("    and" )
   print("  take input lines with two columns.") 
   quit()

pi = np.pi

def str_isfloat(str):
    try:
        float(str)
        return True

    except ValueError:
        return False

if str_isfloat(argvs[1]):
   tune_target = float( argvs[1] )
   fir_filename = argvs[2]
   print("## tune_target = ", tune_target )
else:
   tune_target = 1e6
   fir_filename = argvs[1]

print("## filename : FIR filter coeeficients  = ", fir_filename )



def main():
    print("# fir from ", fir_filename )
    aL, tapL, _ = load_fir( fir_filename )
    ntap = len(aL)
    for i in range( len(aL) ):
        print("# aL  tap   i = ", aL[i], tapL[i], i ) 
    f_target = calc_resp( aL, tapL, tune_target ) 
    dnu_step  = 0.0001
    dnu_start = 0
    dnu_end   = 1
    dnuL = [ dnu for dnu in np.arange( dnu_start, dnu_end, dnu_step ) ]
    if np.abs(tune_target) <= 360 : 
       print("# dnu   Gain  Phase/deg  Gain_effective  phase_extended  phase_delta")
    else:
       print("#dnu Gain Phase/deg")
    n = len(dnuL)
    gainL  = np.zeros(n)
    phaseL = np.zeros(n)
    phase_extL = np.zeros(n)
    phase_deltaL = np.zeros(n)
    phase_target = np.angle( f_target )
    for i in range(len(dnuL)) :
        dnu = dnuL[i]
        f = calc_resp( aL, tapL, dnu )
        gainL[i]  = np.abs( f )
        phaseL[i] = np.angle( f )
        gain = gainL[i]
        phase = gainL[i]
    phase_extL   = phase_extend( phaseL, dnuL, tune_target )     
    phase_deltaL = phase_extL - phase_target
    if np.abs(tune_target) <= 360 : 
       for i in range(len(dnuL)) :
           gain_eff = gainL[i]* np.cos( phaseL[i] - phase_target )
#           print(dnuL[i], gainL[i], (phaseL[i]/pi*180), gain_eff, phase_extL[i]/pi*180, phase_deltaL[i]/pi*180 )
           print("%.8g %.5g  %.5g  %.5g  %.5g  %.5g" % ( dnuL[i], gainL[i], (phaseL[i]/pi*180), gain_eff, phase_extL[i]/pi*180, phase_deltaL[i]/pi*180 ))
    else:
       for i in range(len(dnuL)) :
           print(dnuL[i], gainL[i], (phaseL[i]/pi*180) )

def phase_extend( phaseL, dnuL, tune_target ):
    n = len( dnuL )
    m_min = 1e90
    for i in range(n) :
        m = ( dnuL[i] - tune_target )**2
        if m < m_min:
           m_min = m 
           i_min = i
    phase0 = phaseL[i_min] 
    phase_extL = np.zeros(n)
    for i in range(i_min,n) :
        phase_extL[i] = np.mod( ( phaseL[i] - phase0 + 3*pi ) + 1e5*(2*pi), 2*pi ) -pi + phase0
    for i in range(0,i_min) :
        phase_extL[i] = np.mod( ( phaseL[i] - phase0 + 3*pi ) + 1e5*(2*pi), 2*pi ) -pi + phase0
    return phase_extL
 
def calc_resp( aL, tapL, dnu ):
    f = 0.0 + 0.0j
    for i in range( len(aL) ):
        f += aL[i] * np.exp( -1j * 2 *pi * dnu * tapL[i] )   
    return f

def load_fir( filename ) :
    xl, yl, cl = [],[], []
    with open(filename) as fp:
        for line in fp :
            sl = line.strip()
            if not sl.startswith("#"):
               argvs =  sl.split() 
               if 2 <= len(argvs) :
                  xl.append( float( argvs[0] ) )
                  yl.append( float( argvs[1] ) )
            else:
               cl.append( line )
               print("#C:",line,end="")
    xL = np.array( xl )
    yL = np.array( yl )
    all_positive = ( xL > 0 ).all()
    if np.all( np.sort(xL) == xL ) and all_positive :
       tapL  = xL 
       coefL = yL 
    else:
       tapL  = yL 
       coefL = xL 
    return coefL, tapL, cl



if __name__ == "__main__" :
   main()



#  Fri Nov 15 10:44:05 JST 2024
#  /Users/nakamura/Dropbox/FIR/FIR_tools/coef/python/v5/example
#


#  Mon Nov 18 11:50:02 JST 2024
#  /Users/nakamura/Dropbox/FIR/FIR_tools/coef/python/v5/example/run2
#


#  Mon Nov 18 13:55:45 JST 2024
#  /Users/nakamura/Dropbox/FIR/PF/H_0.39_-124.8deg/16-tap_gain-eff_pp_dir/test
#


#  Fri Jul 4 10:02:36 JST 2025
#  /Users/nakamura/Dropbox/Instrumentation/FIR/SOLEIL_LLFB
#


#  Thu Jan 15 19:01:07 JST 2026
#  /Users/nakamura/Dropbox/Feedback/MR/FIR/H_0.3-0.4_26Jan17/two-sets/data
#
